// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package snowball provides a client for Amazon Import/Export Snowball.
package snowball

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCancelJob = "CancelJob"

// CancelJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelJobRequest method.
//    req, resp := client.CancelJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Snowball) CancelJobRequest(input *CancelJobInput) (req *request.Request, output *CancelJobOutput) {
	op := &request.Operation{
		Name:       opCancelJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelJobOutput{}
	req.Data = output
	return
}

// CancelJob API operation for Amazon Import/Export Snowball.
//
// Cancels the specified job. Note that you can only cancel a job before its
// JobState value changes to PreparingAppliance. Requesting the ListJobs or
// DescribeJob action will return a job's JobState as part of the response element
// data returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CancelJob for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * InvalidJobStateException
//   The action can't be performed because the job's current state doesn't allow
//   that action to be performed.
//
//   * KMSRequestFailedException
//   The provided AWS Key Management Service key lacks the permissions to perform
//   the specified CreateJob or UpdateJob action.
//
func (c *Snowball) CancelJob(input *CancelJobInput) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAddress = "CreateAddress"

// CreateAddressRequest generates a "aws/request.Request" representing the
// client's request for the CreateAddress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateAddress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateAddress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateAddressRequest method.
//    req, resp := client.CreateAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Snowball) CreateAddressRequest(input *CreateAddressInput) (req *request.Request, output *CreateAddressOutput) {
	op := &request.Operation{
		Name:       opCreateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAddressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAddressOutput{}
	req.Data = output
	return
}

// CreateAddress API operation for Amazon Import/Export Snowball.
//
// Creates an address for a Snowball to be shipped to.
//
// Addresses are validated at the time of creation. The address you provide
// must be located within the serviceable area of your region. If the address
// is invalid or unsupported, then an exception is thrown.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CreateAddress for usage and error information.
//
// Returned Error Codes:
//   * InvalidAddressException
//   The address provided was invalid. Check the address with your region's carrier,
//   and try again.
//
//   * UnsupportedAddressException
//   The address is either outside the serviceable area for your region, or an
//   error occurred. Check the address with your region's carrier and try again.
//   If the issue persists, contact AWS Support.
//
func (c *Snowball) CreateAddress(input *CreateAddressInput) (*CreateAddressOutput, error) {
	req, out := c.CreateAddressRequest(input)
	err := req.Send()
	return out, err
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateJobRequest method.
//    req, resp := client.CreateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Snowball) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateJobOutput{}
	req.Data = output
	return
}

// CreateJob API operation for Amazon Import/Export Snowball.
//
// Creates a job to import or export data between Amazon S3 and your on-premises
// data center. Note that your AWS account must have the right trust policies
// and permissions in place to create a job for Snowball. For more information,
// see api-reference-policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CreateJob for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * KMSRequestFailedException
//   The provided AWS Key Management Service key lacks the permissions to perform
//   the specified CreateJob or UpdateJob action.
//
func (c *Snowball) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAddress = "DescribeAddress"

// DescribeAddressRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAddress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAddress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAddressRequest method.
//    req, resp := client.DescribeAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Snowball) DescribeAddressRequest(input *DescribeAddressInput) (req *request.Request, output *DescribeAddressOutput) {
	op := &request.Operation{
		Name:       opDescribeAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAddressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAddressOutput{}
	req.Data = output
	return
}

// DescribeAddress API operation for Amazon Import/Export Snowball.
//
// Takes an AddressId and returns specific details about that address in the
// form of an Address object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation DescribeAddress for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
func (c *Snowball) DescribeAddress(input *DescribeAddressInput) (*DescribeAddressOutput, error) {
	req, out := c.DescribeAddressRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAddresses = "DescribeAddresses"

// DescribeAddressesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddresses operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAddresses for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAddresses method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAddressesRequest method.
//    req, resp := client.DescribeAddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Snowball) DescribeAddressesRequest(input *DescribeAddressesInput) (req *request.Request, output *DescribeAddressesOutput) {
	op := &request.Operation{
		Name:       opDescribeAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAddressesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAddressesOutput{}
	req.Data = output
	return
}

// DescribeAddresses API operation for Amazon Import/Export Snowball.
//
// Returns a specified number of ADDRESS objects. Calling this API in one of
// the US regions will return addresses from the list of all addresses associated
// with this account in all US regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation DescribeAddresses for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
func (c *Snowball) DescribeAddresses(input *DescribeAddressesInput) (*DescribeAddressesOutput, error) {
	req, out := c.DescribeAddressesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeAddressesPages iterates over the pages of a DescribeAddresses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAddresses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAddresses operation.
//    pageNum := 0
//    err := client.DescribeAddressesPages(params,
//        func(page *DescribeAddressesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Snowball) DescribeAddressesPages(input *DescribeAddressesInput, fn func(p *DescribeAddressesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeAddressesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeAddressesOutput), lastPage)
	})
}

const opDescribeJob = "DescribeJob"

// DescribeJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeJobRequest method.
//    req, resp := client.DescribeJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Snowball) DescribeJobRequest(input *DescribeJobInput) (req *request.Request, output *DescribeJobOutput) {
	op := &request.Operation{
		Name:       opDescribeJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeJobOutput{}
	req.Data = output
	return
}

// DescribeJob API operation for Amazon Import/Export Snowball.
//
// Returns information about a specific job including shipping information,
// job status, and other important metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation DescribeJob for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
func (c *Snowball) DescribeJob(input *DescribeJobInput) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	err := req.Send()
	return out, err
}

const opGetJobManifest = "GetJobManifest"

// GetJobManifestRequest generates a "aws/request.Request" representing the
// client's request for the GetJobManifest operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetJobManifest for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetJobManifest method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetJobManifestRequest method.
//    req, resp := client.GetJobManifestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Snowball) GetJobManifestRequest(input *GetJobManifestInput) (req *request.Request, output *GetJobManifestOutput) {
	op := &request.Operation{
		Name:       opGetJobManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobManifestInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetJobManifestOutput{}
	req.Data = output
	return
}

// GetJobManifest API operation for Amazon Import/Export Snowball.
//
// Returns a link to an Amazon S3 presigned URL for the manifest file associated
// with the specified JobId value. You can access the manifest file for up to
// 60 minutes after this request has been made. To access the manifest file
// after 60 minutes have passed, you'll have to make another call to the GetJobManifest
// action.
//
// The manifest is an encrypted file that you can download after your job enters
// the WithCustomer status. The manifest is decrypted by using the UnlockCode
// code value, when you pass both values to the Snowball through the Snowball
// client when the client is started for the first time.
//
// As a best practice, we recommend that you don't save a copy of an UnlockCode
// value in the same location as the manifest file for that job. Saving these
// separately helps prevent unauthorized parties from gaining access to the
// Snowball associated with that job.
//
// Note that the credentials of a given job, including its manifest file and
// unlock code, expire 90 days after the job is created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation GetJobManifest for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * InvalidJobStateException
//   The action can't be performed because the job's current state doesn't allow
//   that action to be performed.
//
func (c *Snowball) GetJobManifest(input *GetJobManifestInput) (*GetJobManifestOutput, error) {
	req, out := c.GetJobManifestRequest(input)
	err := req.Send()
	return out, err
}

const opGetJobUnlockCode = "GetJobUnlockCode"

// GetJobUnlockCodeRequest generates a "aws/request.Request" representing the
// client's request for the GetJobUnlockCode operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetJobUnlockCode for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetJobUnlockCode method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetJobUnlockCodeRequest method.
//    req, resp := client.GetJobUnlockCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Snowball) GetJobUnlockCodeRequest(input *GetJobUnlockCodeInput) (req *request.Request, output *GetJobUnlockCodeOutput) {
	op := &request.Operation{
		Name:       opGetJobUnlockCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobUnlockCodeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetJobUnlockCodeOutput{}
	req.Data = output
	return
}

// GetJobUnlockCode API operation for Amazon Import/Export Snowball.
//
// Returns the UnlockCode code value for the specified job. A particular UnlockCode
// value can be accessed for up to 90 days after the associated job has been
// created.
//
// The UnlockCode value is a 29-character code with 25 alphanumeric characters
// and 4 hyphens. This code is used to decrypt the manifest file when it is
// passed along with the manifest to the Snowball through the Snowball client
// when the client is started for the first time.
//
// As a best practice, we recommend that you don't save a copy of the UnlockCode
// in the same location as the manifest file for that job. Saving these separately
// helps prevent unauthorized parties from gaining access to the Snowball associated
// with that job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation GetJobUnlockCode for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * InvalidJobStateException
//   The action can't be performed because the job's current state doesn't allow
//   that action to be performed.
//
func (c *Snowball) GetJobUnlockCode(input *GetJobUnlockCodeInput) (*GetJobUnlockCodeOutput, error) {
	req, out := c.GetJobUnlockCodeRequest(input)
	err := req.Send()
	return out, err
}

const opGetSnowballUsage = "GetSnowballUsage"

// GetSnowballUsageRequest generates a "aws/request.Request" representing the
// client's request for the GetSnowballUsage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSnowballUsage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSnowballUsage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSnowballUsageRequest method.
//    req, resp := client.GetSnowballUsageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Snowball) GetSnowballUsageRequest(input *GetSnowballUsageInput) (req *request.Request, output *GetSnowballUsageOutput) {
	op := &request.Operation{
		Name:       opGetSnowballUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSnowballUsageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSnowballUsageOutput{}
	req.Data = output
	return
}

// GetSnowballUsage API operation for Amazon Import/Export Snowball.
//
// Returns information about the Snowball service limit for your account, and
// also the number of Snowballs your account has in use.
//
// Note that the default service limit for the number of Snowballs that you
// can have at one time is 1. If you want to increase your service limit, contact
// AWS Support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation GetSnowballUsage for usage and error information.
func (c *Snowball) GetSnowballUsage(input *GetSnowballUsageInput) (*GetSnowballUsageOutput, error) {
	req, out := c.GetSnowballUsageRequest(input)
	err := req.Send()
	return out, err
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListJobs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListJobs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Snowball) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListJobsOutput{}
	req.Data = output
	return
}

// ListJobs API operation for Amazon Import/Export Snowball.
//
// Returns an array of JobListEntry objects of the specified length. Each JobListEntry
// object contains a job's state, a job's ID, and a value that indicates whether
// the job is a job part, in the case of export jobs. Calling this API action
// in one of the US regions will return jobs from the list of all jobs associated
// with this account in all US regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation ListJobs for usage and error information.
func (c *Snowball) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	err := req.Send()
	return out, err
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListJobs operation.
//    pageNum := 0
//    err := client.ListJobsPages(params,
//        func(page *ListJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Snowball) ListJobsPages(input *ListJobsInput, fn func(p *ListJobsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListJobsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListJobsOutput), lastPage)
	})
}

const opUpdateJob = "UpdateJob"

// UpdateJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateJobRequest method.
//    req, resp := client.UpdateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Snowball) UpdateJobRequest(input *UpdateJobInput) (req *request.Request, output *UpdateJobOutput) {
	op := &request.Operation{
		Name:       opUpdateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateJobOutput{}
	req.Data = output
	return
}

// UpdateJob API operation for Amazon Import/Export Snowball.
//
// While a job's JobState value is New, you can update some of the information
// associated with a job. Once the job changes to a different job state, usually
// within 60 minutes of the job being created, this action is no longer available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation UpdateJob for usage and error information.
//
// Returned Error Codes:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * InvalidJobStateException
//   The action can't be performed because the job's current state doesn't allow
//   that action to be performed.
//
//   * KMSRequestFailedException
//   The provided AWS Key Management Service key lacks the permissions to perform
//   the specified CreateJob or UpdateJob action.
//
func (c *Snowball) UpdateJob(input *UpdateJobInput) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	err := req.Send()
	return out, err
}

// The address that you want the Snowball or Snowballs associated with a specific
// job to be shipped to. Addresses are validated at the time of creation. The
// address you provide must be located within the serviceable area of your region.
// Although no individual elements of the Address are required, if the address
// is invalid or unsupported, then an exception is thrown.
type Address struct {
	_ struct{} `type:"structure"`

	// The unique ID for an address.
	AddressId *string `min:"40" type:"string"`

	// The city in an address that a Snowball is to be delivered to.
	City *string `min:"1" type:"string"`

	// The name of the company to receive a Snowball at an address.
	Company *string `min:"1" type:"string"`

	// The country in an address that a Snowball is to be delivered to.
	Country *string `min:"1" type:"string"`

	// A landmark listed in an address that a Snowball is to be delivered to.
	Landmark *string `min:"1" type:"string"`

	// The name of a person to receive a Snowball at an address.
	Name *string `min:"1" type:"string"`

	// The phone number associated with an address that a Snowball is to be delivered
	// to.
	PhoneNumber *string `min:"1" type:"string"`

	// The postal code in an address that a Snowball is to be delivered to.
	PostalCode *string `min:"1" type:"string"`

	// The prefecture or district in an address that a Snowball is to be delivered
	// to.
	PrefectureOrDistrict *string `min:"1" type:"string"`

	// The state or province in an address that a Snowball is to be delivered to.
	StateOrProvince *string `min:"1" type:"string"`

	// The first line in a street address that a Snowball is to be delivered to.
	Street1 *string `min:"1" type:"string"`

	// The second line in a street address that a Snowball is to be delivered to.
	Street2 *string `min:"1" type:"string"`

	// The third line in a street address that a Snowball is to be delivered to.
	Street3 *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Address) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Address) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Address"}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.City != nil && len(*s.City) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("City", 1))
	}
	if s.Company != nil && len(*s.Company) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Company", 1))
	}
	if s.Country != nil && len(*s.Country) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Country", 1))
	}
	if s.Landmark != nil && len(*s.Landmark) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Landmark", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PhoneNumber != nil && len(*s.PhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumber", 1))
	}
	if s.PostalCode != nil && len(*s.PostalCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PostalCode", 1))
	}
	if s.PrefectureOrDistrict != nil && len(*s.PrefectureOrDistrict) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrefectureOrDistrict", 1))
	}
	if s.StateOrProvince != nil && len(*s.StateOrProvince) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateOrProvince", 1))
	}
	if s.Street1 != nil && len(*s.Street1) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Street1", 1))
	}
	if s.Street2 != nil && len(*s.Street2) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Street2", 1))
	}
	if s.Street3 != nil && len(*s.Street3) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Street3", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CancelJobInput struct {
	_ struct{} `type:"structure"`

	// The 39 character job ID for the job that you want to cancel, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CancelJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobOutput) GoString() string {
	return s.String()
}

type CreateAddressInput struct {
	_ struct{} `type:"structure"`

	// The address that you want the Snowball shipped to.
	//
	// Address is a required field
	Address *Address `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAddressInput"}
	if s.Address == nil {
		invalidParams.Add(request.NewErrParamRequired("Address"))
	}
	if s.Address != nil {
		if err := s.Address.Validate(); err != nil {
			invalidParams.AddNested("Address", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateAddressOutput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a specific address. You'll use this ID
	// when you create a job to specify which address you want the Snowball for
	// that job shipped to.
	AddressId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAddressOutput) GoString() string {
	return s.String()
}

type CreateJobInput struct {
	_ struct{} `type:"structure"`

	// The ID for the address that you want the Snowball shipped to.
	//
	// AddressId is a required field
	AddressId *string `min:"40" type:"string" required:"true"`

	// Defines an optional description of this specific job, for example Important
	// Photos 2016-08-11.
	Description *string `min:"1" type:"string"`

	// Defines the type of job that you're creating.
	//
	// JobType is a required field
	JobType *string `type:"string" required:"true" enum:"JobType"`

	// The KmsKeyARN that you want to associate with this job. KmsKeyARNs are created
	// using the CreateKey (http://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html)
	// AWS Key Management Service (KMS) API action.
	KmsKeyARN *string `type:"string"`

	// Defines the Amazon Simple Notification Service (Amazon SNS) notification
	// settings for this job.
	Notification *Notification `type:"structure"`

	// Defines the Amazon S3 buckets associated with this job.
	//
	// With IMPORT jobs, you specify the bucket or buckets that your transferred
	// data will be imported into.
	//
	// With EXPORT jobs, you specify the bucket or buckets that your transferred
	// data will be exported from. Optionally, you can also specify a KeyRange value.
	// If you choose to export a range, you define the length of the range by providing
	// either an inclusive BeginMarker value, an inclusive EndMarker value, or both.
	// Ranges are UTF-8 binary sorted.
	//
	// Resources is a required field
	Resources *JobResource `type:"structure" required:"true"`

	// The RoleARN that you want to associate with this job. RoleArns are created
	// using the CreateRole (http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)
	// AWS Identity and Access Management (IAM) API action.
	//
	// RoleARN is a required field
	RoleARN *string `type:"string" required:"true"`

	// The shipping speed for this job. Note that this speed does not dictate how
	// soon you'll get the Snowball, rather it represents how quickly the Snowball
	// moves to its destination while in transit. Regional shipping speeds are as
	// follows:
	//
	//    * In Australia, you have access to express shipping. Typically, Snowballs
	//    shipped express are delivered in about a day.
	//
	//    * In the European Union (EU), you have access to express shipping. Typically,
	//    Snowballs shipped express are delivered in about a day. In addition, most
	//    countries in the EU have access to standard shipping, which typically
	//    takes less than a week, one way.
	//
	//    * In India, Snowballs are delivered in one to seven days.
	//
	//    * In the US, you have access to one-day shipping and two-day shipping.
	//
	// ShippingOption is a required field
	ShippingOption *string `type:"string" required:"true" enum:"ShippingOption"`

	// If your job is being created in one of the US regions, you have the option
	// of specifying what size Snowball you'd like for this job. In all other regions,
	// Snowballs come with 80 TB in storage capacity.
	SnowballCapacityPreference *string `type:"string" enum:"Capacity"`
}

// String returns the string representation
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.AddressId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressId"))
	}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.JobType == nil {
		invalidParams.Add(request.NewErrParamRequired("JobType"))
	}
	if s.Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("Resources"))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.ShippingOption == nil {
		invalidParams.Add(request.NewErrParamRequired("ShippingOption"))
	}
	if s.Resources != nil {
		if err := s.Resources.Validate(); err != nil {
			invalidParams.AddNested("Resources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	JobId *string `min:"39" type:"string"`
}

// String returns the string representation
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// Defines the real-time status of a Snowball's data transfer while the appliance
// is at AWS. Note that this data is only available while a job has a JobState
// value of InProgress, for both import and export jobs.
type DataTransfer struct {
	_ struct{} `type:"structure"`

	// The number of bytes transferred between a Snowball and Amazon S3.
	BytesTransferred *int64 `type:"long"`

	// The number of objects transferred between a Snowball and Amazon S3.
	ObjectsTransferred *int64 `type:"long"`

	// The total bytes of data for a transfer between a Snowball and Amazon S3.
	// This value is set to 0 (zero) until all the keys that will be transferred
	// have been listed.
	TotalBytes *int64 `type:"long"`

	// The total number of objects for a transfer between a Snowball and Amazon
	// S3. This value is set to 0 (zero) until all the keys that will be transferred
	// have been listed.
	TotalObjects *int64 `type:"long"`
}

// String returns the string representation
func (s DataTransfer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataTransfer) GoString() string {
	return s.String()
}

type DescribeAddressInput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a specific address.
	//
	// AddressId is a required field
	AddressId *string `min:"40" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddressInput"}
	if s.AddressId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressId"))
	}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAddressOutput struct {
	_ struct{} `type:"structure"`

	// The address that you want the Snowball or Snowballs associated with a specific
	// job to be shipped to.
	Address *Address `type:"structure"`
}

// String returns the string representation
func (s DescribeAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressOutput) GoString() string {
	return s.String()
}

type DescribeAddressesInput struct {
	_ struct{} `type:"structure"`

	// The number of ADDRESS objects to return.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of ADDRESS objects, you have the option of specifying a value for NextToken
	// as the starting point for your list of returned addresses.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddressesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddressesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAddressesOutput struct {
	_ struct{} `type:"structure"`

	// The Snowball shipping addresses that were created for this account.
	Addresses []*Address `type:"list"`

	// HTTP requests are stateless. If you use the automatically generated NextToken
	// value in your next DescribeAddresses call, your list of returned addresses
	// will start from this point in the array.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressesOutput) GoString() string {
	return s.String()
}

type DescribeJobInput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeJobOutput struct {
	_ struct{} `type:"structure"`

	// Information about a specific job, including shipping information, job status,
	// and other important metadata.
	JobMetadata *JobMetadata `type:"structure"`

	// Information about a specific job part (in the case of an export job), including
	// shipping information, job status, and other important metadata.
	SubJobMetadata []*JobMetadata `type:"list"`
}

// String returns the string representation
func (s DescribeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobOutput) GoString() string {
	return s.String()
}

type GetJobManifestInput struct {
	_ struct{} `type:"structure"`

	// The ID for a job that you want to get the manifest file for, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobManifestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobManifestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobManifestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobManifestInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetJobManifestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 presigned URL for the manifest file associated with the specified
	// JobId value.
	ManifestURI *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetJobManifestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobManifestOutput) GoString() string {
	return s.String()
}

type GetJobUnlockCodeInput struct {
	_ struct{} `type:"structure"`

	// The ID for the job that you want to get the UnlockCode value for, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobUnlockCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobUnlockCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobUnlockCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobUnlockCodeInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetJobUnlockCodeOutput struct {
	_ struct{} `type:"structure"`

	// The UnlockCode value for the specified job. The UnlockCode value can be accessed
	// for up to 90 days after the job has been created.
	UnlockCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetJobUnlockCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobUnlockCodeOutput) GoString() string {
	return s.String()
}

type GetSnowballUsageInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetSnowballUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSnowballUsageInput) GoString() string {
	return s.String()
}

type GetSnowballUsageOutput struct {
	_ struct{} `type:"structure"`

	// The service limit for number of Snowballs this account can have at once.
	// The default service limit is 1 (one).
	SnowballLimit *int64 `type:"integer"`

	// The number of Snowballs that this account is currently using.
	SnowballsInUse *int64 `type:"integer"`
}

// String returns the string representation
func (s GetSnowballUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSnowballUsageOutput) GoString() string {
	return s.String()
}

// Each JobListEntry object contains a job's state, a job's ID, and a value
// that indicates whether the job is a job part, in the case of an export job.
type JobListEntry struct {
	_ struct{} `type:"structure"`

	// A value that indicates that this job is a master job. A master job represents
	// a successful request to create an export job. Master jobs aren't associated
	// with any Snowballs. Instead, each master job will have at least one job part,
	// and each job part is associated with a Snowball. It might take some time
	// before the job parts associated with a particular master job are listed,
	// because they are created after the master job is created.
	IsMaster *bool `type:"boolean"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	JobId *string `min:"1" type:"string"`

	// The current state of this job.
	JobState *string `type:"string" enum:"JobState"`
}

// String returns the string representation
func (s JobListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobListEntry) GoString() string {
	return s.String()
}

// Contains job logs. Whenever Snowball is used to import data into or export
// data out of Amazon S3, you'll have the option of downloading a PDF job report.
// Job logs are returned as a part of the response syntax of the DescribeJob
// action in the JobMetadata data type. The job logs can be accessed for up
// to 60 minutes after this request has been made. To access any of the job
// logs after 60 minutes have passed, you'll have to make another call to the
// DescribeJob action.
//
// For import jobs, the PDF job report becomes available at the end of the import
// process. For export jobs, your job report typically becomes available while
// the Snowball for your job part is being delivered to you.
//
// The job report provides you insight into the state of your Amazon S3 data
// transfer. The report includes details about your job or job part for your
// records.
//
// For deeper visibility into the status of your transferred objects, you can
// look at the two associated logs: a success log and a failure log. The logs
// are saved in comma-separated value (CSV) format, and the name of each log
// includes the ID of the job or job part that the log describes.
type JobLogs struct {
	_ struct{} `type:"structure"`

	// A link to an Amazon S3 presigned URL where the job completion report is located.
	JobCompletionReportURI *string `min:"1" type:"string"`

	// A link to an Amazon S3 presigned URL where the job failure log is located.
	JobFailureLogURI *string `min:"1" type:"string"`

	// A link to an Amazon S3 presigned URL where the job success log is located.
	JobSuccessLogURI *string `min:"1" type:"string"`
}

// String returns the string representation
func (s JobLogs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobLogs) GoString() string {
	return s.String()
}

// Contains information about a specific job including shipping information,
// job status, and other important metadata. This information is returned as
// a part of the response syntax of the DescribeJob action.
type JobMetadata struct {
	_ struct{} `type:"structure"`

	// The ID for the address that you want the Snowball shipped to.
	AddressId *string `min:"40" type:"string"`

	// The creation date for this job.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A value that defines the real-time status of a Snowball's data transfer while
	// the appliance is at AWS. Note that this data is only available while a job
	// has a JobState value of InProgress, for both import and export jobs.
	DataTransferProgress *DataTransfer `type:"structure"`

	// The description of the job, provided at job creation.
	Description *string `min:"1" type:"string"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	JobId *string `min:"1" type:"string"`

	// Links to Amazon S3 presigned URLs for the job report and logs. For import
	// jobs, the PDF job report becomes available at the end of the import process.
	// For export jobs, your job report typically becomes available while the Snowball
	// for your job part is being delivered to you.
	JobLogInfo *JobLogs `type:"structure"`

	// The current state of the jobs.
	JobState *string `type:"string" enum:"JobState"`

	// The type of job.
	JobType *string `type:"string" enum:"JobType"`

	// The Amazon Resource Name (ARN) for the AWS Key Management Service (AWS KMS)
	// key associated with this job. This ARN was created using the CreateKey API
	// action in AWS KMS.
	KmsKeyARN *string `type:"string"`

	// The Amazon Simple Notification Service (Amazon SNS) notification settings
	// associated with a specific job. The Notification object is returned as a
	// part of the response syntax of the DescribeJob action in the JobMetadata
	// data type.
	Notification *Notification `type:"structure"`

	// An array of S3Resource objects. Each S3Resource object represents an Amazon
	// S3 bucket that your transferred data will be exported from or imported into.
	Resources *JobResource `type:"structure"`

	// The role ARN associated with this job. This ARN was created using the CreateRole
	// API action in AWS Identity and Access Management (IAM).
	RoleARN *string `type:"string"`

	// A job's shipping information, including inbound and outbound tracking numbers
	// and shipping speed options.
	ShippingDetails *ShippingDetails `type:"structure"`

	// The Snowball capacity preference for this job, specified at job creation.
	// In US regions, you can choose between 50 TB and 80 TB Snowballs. All other
	// regions use 80 TB capacity Snowballs.
	SnowballCapacityPreference *string `type:"string" enum:"Capacity"`
}

// String returns the string representation
func (s JobMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobMetadata) GoString() string {
	return s.String()
}

// Contains an array of S3Resource objects. Each S3Resource object represents
// an Amazon S3 bucket that your transferred data will be exported from or imported
// into.
type JobResource struct {
	_ struct{} `type:"structure"`

	// An array of S3Resource objects.
	S3Resources []*S3Resource `type:"list"`
}

// String returns the string representation
func (s JobResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobResource"}
	if s.S3Resources != nil {
		for i, v := range s.S3Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "S3Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains a key range. For export jobs, a S3Resource object can have an optional
// KeyRange value. The length of the range is defined at job creation, and has
// either an inclusive BeginMarker, an inclusive EndMarker, or both. Ranges
// are UTF-8 binary sorted.
type KeyRange struct {
	_ struct{} `type:"structure"`

	// The key that starts an optional key range for an export job. Ranges are inclusive
	// and UTF-8 binary sorted.
	BeginMarker *string `min:"1" type:"string"`

	// The key that ends an optional key range for an export job. Ranges are inclusive
	// and UTF-8 binary sorted.
	EndMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KeyRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyRange"}
	if s.BeginMarker != nil && len(*s.BeginMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BeginMarker", 1))
	}
	if s.EndMarker != nil && len(*s.EndMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListJobsInput struct {
	_ struct{} `type:"structure"`

	// The number of JobListEntry objects to return.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of JobListEntry objects, you have the option of specifying NextToken
	// as the starting point for your returned list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// Each JobListEntry object contains a job's state, a job's ID, and a value
	// that indicates whether the job is a job part, in the case of export jobs.
	JobListEntries []*JobListEntry `type:"list"`

	// HTTP requests are stateless. If you use this automatically generated NextToken
	// value in your next ListJobs call, your returned JobListEntry objects will
	// start from this point in the array.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// The Amazon Simple Notification Service (Amazon SNS) notification settings
// associated with a specific job. The Notification object is returned as a
// part of the response syntax of the DescribeJob action in the JobMetadata
// data type.
//
// When the notification settings are defined during job creation, you can choose
// to notify based on a specific set of job states using the JobStatesToNotify
// array of strings, or you can specify that you want to have Amazon SNS notifications
// sent out for all job states with NotifyAll set to true.
type Notification struct {
	_ struct{} `type:"structure"`

	// The list of job states that will trigger a notification for this job.
	JobStatesToNotify []*string `type:"list"`

	// Any change in job state will trigger a notification for this job.
	NotifyAll *bool `type:"boolean"`

	// The new SNS TopicArn that you want to associate with this job. You can create
	// Amazon Resource Names (ARNs) for topics by using the CreateTopic (http://docs.aws.amazon.com/sns/latest/api/API_CreateTopic.html)
	// Amazon SNS API action.
	//
	// Note that you can subscribe email addresses to an Amazon SNS topic through
	// the AWS Management Console, or by using the Subscribe (http://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)
	// AWS Simple Notification Service (SNS) API action.
	SnsTopicARN *string `type:"string"`
}

// String returns the string representation
func (s Notification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Notification) GoString() string {
	return s.String()
}

// Each S3Resource object represents an Amazon S3 bucket that your transferred
// data will be exported from or imported into. For export jobs, this object
// can have an optional KeyRange value. The length of the range is defined at
// job creation, and has either an inclusive BeginMarker, an inclusive EndMarker,
// or both. Ranges are UTF-8 binary sorted.
type S3Resource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon S3 bucket.
	BucketArn *string `type:"string"`

	// For export jobs, you can provide an optional KeyRange within a specific Amazon
	// S3 bucket. The length of the range is defined at job creation, and has either
	// an inclusive BeginMarker, an inclusive EndMarker, or both. Ranges are UTF-8
	// binary sorted.
	KeyRange *KeyRange `type:"structure"`
}

// String returns the string representation
func (s S3Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Resource"}
	if s.KeyRange != nil {
		if err := s.KeyRange.Validate(); err != nil {
			invalidParams.AddNested("KeyRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Status and TrackingNumber information for an inbound or outbound shipment.
type Shipment struct {
	_ struct{} `type:"structure"`

	// Status information for a shipment. Valid statuses include NEW, IN_TRANSIT,
	// and DELIVERED.
	Status *string `min:"1" type:"string"`

	// The tracking number for this job. Using this tracking number with your region's
	// carrier's website, you can track a Snowball as the carrier transports it.
	//
	// For India, the carrier is Amazon Logistics. For all other regions, UPS is
	// the carrier.
	TrackingNumber *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Shipment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Shipment) GoString() string {
	return s.String()
}

// A job's shipping information, including inbound and outbound tracking numbers
// and shipping speed options.
type ShippingDetails struct {
	_ struct{} `type:"structure"`

	// The Status and TrackingNumber values for a Snowball being delivered to the
	// address that you specified for a particular job.
	InboundShipment *Shipment `type:"structure"`

	// The Status and TrackingNumber values for a Snowball being returned to AWS
	// for a particular job.
	OutboundShipment *Shipment `type:"structure"`

	// The shipping speed for a particular job. Note that this speed does not dictate
	// how soon you'll get the Snowball from the job's creation date. This speed
	// represents how quickly it moves to its destination while in transit. Regional
	// shipping speeds are as follows:
	//
	//    * In Australia, you have access to express shipping. Typically, Snowballs
	//    shipped express are delivered in about a day.
	//
	//    * In the European Union (EU), you have access to express shipping. Typically,
	//    Snowballs shipped express are delivered in about a day. In addition, most
	//    countries in the EU have access to standard shipping, which typically
	//    takes less than a week, one way.
	//
	//    * In India, Snowballs are delivered in one to seven days.
	//
	//    * In the United States of America (US), you have access to one-day shipping
	//    and two-day shipping.
	ShippingOption *string `type:"string" enum:"ShippingOption"`
}

// String returns the string representation
func (s ShippingDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShippingDetails) GoString() string {
	return s.String()
}

type UpdateJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the updated Address object.
	AddressId *string `min:"40" type:"string"`

	// The updated description of this job's JobMetadata object.
	Description *string `min:"1" type:"string"`

	// The job ID of the job that you want to update, for example JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`

	// The new or updated Notification object.
	Notification *Notification `type:"structure"`

	// The updated S3Resource object (for a single Amazon S3 bucket or key range),
	// or the updated JobResource object (for multiple buckets or key ranges).
	Resources *JobResource `type:"structure"`

	// The new role Amazon Resource Name (ARN) that you want to associate with this
	// job. To create a role ARN, use the CreateRole (http://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)
	// AWS Identity and Access Management (IAM) API action.
	RoleARN *string `type:"string"`

	// The updated shipping option value of this job's ShippingDetails object.
	ShippingOption *string `type:"string" enum:"ShippingOption"`

	// The updated SnowballCapacityPreference of this job's JobMetadata object.
	// Note that the 50 TB Snowballs are only available in the US regions.
	SnowballCapacityPreference *string `type:"string" enum:"Capacity"`
}

// String returns the string representation
func (s UpdateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateJobInput"}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}
	if s.Resources != nil {
		if err := s.Resources.Validate(); err != nil {
			invalidParams.AddNested("Resources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobOutput) GoString() string {
	return s.String()
}

const (
	// CapacityT50 is a Capacity enum value
	CapacityT50 = "T50"

	// CapacityT80 is a Capacity enum value
	CapacityT80 = "T80"

	// CapacityNoPreference is a Capacity enum value
	CapacityNoPreference = "NoPreference"
)

const (
	// JobStateNew is a JobState enum value
	JobStateNew = "New"

	// JobStatePreparingAppliance is a JobState enum value
	JobStatePreparingAppliance = "PreparingAppliance"

	// JobStatePreparingShipment is a JobState enum value
	JobStatePreparingShipment = "PreparingShipment"

	// JobStateInTransitToCustomer is a JobState enum value
	JobStateInTransitToCustomer = "InTransitToCustomer"

	// JobStateWithCustomer is a JobState enum value
	JobStateWithCustomer = "WithCustomer"

	// JobStateInTransitToAws is a JobState enum value
	JobStateInTransitToAws = "InTransitToAWS"

	// JobStateWithAws is a JobState enum value
	JobStateWithAws = "WithAWS"

	// JobStateInProgress is a JobState enum value
	JobStateInProgress = "InProgress"

	// JobStateComplete is a JobState enum value
	JobStateComplete = "Complete"

	// JobStateCancelled is a JobState enum value
	JobStateCancelled = "Cancelled"

	// JobStateListing is a JobState enum value
	JobStateListing = "Listing"

	// JobStatePending is a JobState enum value
	JobStatePending = "Pending"
)

const (
	// JobTypeImport is a JobType enum value
	JobTypeImport = "IMPORT"

	// JobTypeExport is a JobType enum value
	JobTypeExport = "EXPORT"
)

const (
	// ShippingOptionSecondDay is a ShippingOption enum value
	ShippingOptionSecondDay = "SECOND_DAY"

	// ShippingOptionNextDay is a ShippingOption enum value
	ShippingOptionNextDay = "NEXT_DAY"

	// ShippingOptionExpress is a ShippingOption enum value
	ShippingOptionExpress = "EXPRESS"

	// ShippingOptionStandard is a ShippingOption enum value
	ShippingOptionStandard = "STANDARD"
)
